/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.html;

import icyllis.annotations.NotNull;
import icyllis.flexmark.html.HtmlWriter;
import icyllis.flexmark.html.NodeRenderingHandlerWrapper;
import icyllis.flexmark.html.renderer.NodeRendererContext;
import icyllis.flexmark.util.ast.Node;
import java.io.IOException;

public abstract class NodeRendererSubContext
implements NodeRendererContext {
    final HtmlWriter htmlWriter;
    Node renderingNode;
    NodeRenderingHandlerWrapper renderingHandlerWrapper;
    int doNotRenderLinksNesting;

    public NodeRendererSubContext(@NotNull HtmlWriter htmlWriter) {
        this.htmlWriter = htmlWriter;
        this.renderingNode = null;
        this.doNotRenderLinksNesting = 0;
    }

    @Override
    @NotNull
    public HtmlWriter getHtmlWriter() {
        return this.htmlWriter;
    }

    public void flushTo(@NotNull Appendable out, int maxTrailingBlankLines) {
        this.flushTo(out, this.getHtmlOptions().maxBlankLines, maxTrailingBlankLines);
    }

    public void flushTo(@NotNull Appendable out, int maxBlankLines, int maxTrailingBlankLines) {
        this.htmlWriter.line();
        try {
            this.htmlWriter.appendTo(out, maxBlankLines, maxTrailingBlankLines);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected int getDoNotRenderLinksNesting() {
        return this.doNotRenderLinksNesting;
    }

    @Override
    public boolean isDoNotRenderLinks() {
        return this.doNotRenderLinksNesting != 0;
    }

    @Override
    public void doNotRenderLinks(boolean doNotRenderLinks) {
        if (doNotRenderLinks) {
            this.doNotRenderLinks();
        } else {
            this.doRenderLinks();
        }
    }

    @Override
    public void doNotRenderLinks() {
        ++this.doNotRenderLinksNesting;
    }

    @Override
    public void doRenderLinks() {
        if (this.doNotRenderLinksNesting == 0) {
            throw new IllegalStateException("Not in do not render links context");
        }
        --this.doNotRenderLinksNesting;
    }
}

